--------------------------------------------------------------------
--            SymCACP Script Module 1       
-- Symmetrical CA Control Panel   symCACPscript-1
--file for Staining Changes
-- modified for script2
--------------------------------------------------------------------
--  P. Rendell   24/11/2022
--------------------------------------------------------------------

--==============================================================================
------------------------------------------------------------

local scriptType = "script-Stain"
local m={}			-- class table
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local logDiverted = false
m.colonList = {}
m.equalList = {['GENS'] = {'d',""}, ['ONECHANGE'] = {'l',"R"}}
------------------------------------------------------------------------------------------------


--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      m.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = "D"
   end
   return true
end
--==============================================================================
--==============================================================================

function showStates(patt)
   local newPatt = {}
   local st={0,0,0}     
   for i = 1, #patt, 3 do
      if #patt >= i+2 then
         g.show("#patt "..#patt.." i "..i.." s "..patt[i+2])
         g.show("#patt "..#patt.." i "..i.." s "..patt[i+2].." st[1] "..st[1])
         st[patt[i+2]+1] =  st[patt[i+2]+1] + 1 
      end
   end
   g.show("s0 "..st[1].." st1 "..st[2].." st2 "..st[3] )
end
--==============================================================================
function logStates(txt,patt)
   local fmt = 2
   if ( #patt%2 == 1 ) then
      fmt = 3
   end
   local lineLen = 5
   local lineCnt = lineLen
   local str = txt.."\n"
   local sep = ""
   for i = 1, #patt, fmt do
      if #patt >= i+2 then
         if (fmt == 3 ) then
            str = str..sep.."("..patt[i]..","..patt[i+1]..":"..patt[i+2]..")"
         else
            str = str..sep.."("..patt[i]..","..patt[i+1]..")"
         end
         lineCnt = lineCnt -1
         if ( lineCnt < 1 ) then
            str = str .."\n"
            sep = ""
            lineCnt = lineLen
         else
            sep = ", "
         end
      end
   end
   if (lineCnt ~= lineLen) then
       str = str.."\n"
   end
   logFile:write(str)
end
--==============================================================================

function threeState2two(patt)
   local newPatt = {}
   
   if #patt%2 == 1 then     
      for i = 1, #patt, 3 do
         if #patt >= i+2 then
            if patt[i+2] == 1 then
               newPatt[#newPatt+1] = patt[i]
               newPatt[#newPatt+1] = patt[i+1]
            end
         end
      end
   else
      newPatt = patt
   end   
   return (newPatt)
end
--==============================================================================

function twoState2tthree(patt1,patt2)
   local newPatt = {}
   
   if #patt1%2 == 1 then  
      for i = 1, #patt1, 3 do
         if #patt1 >= i+2 then
            if patt1[i+2] == 1 then
               newPatt[#newPatt+1] = patt1[i]
               newPatt[#newPatt+1] = patt1[i+1]
               newPatt[#newPatt+1] = 1
            end
         end
      end
   else
      for i = 1, #patt1, 2 do
         if #patt1 >= i+1 then
            newPatt[#newPatt+1] = patt1[i]
            newPatt[#newPatt+1] = patt1[i+1]
            newPatt[#newPatt+1] = 1
         end
      end
   end
   
   if #patt2%2 == 1 then  
      for i = 1, #patt2, 3 do
         if #patt2 >= i+2 then
            if patt2[i+2] == 1 then
               newPatt[#newPatt+1] = patt2[i]
               newPatt[#newPatt+1] = patt2[i+1]
               newPatt[#newPatt+1] = 2
            end
         end
      end
   else
      for i = 1, #patt2, 2 do
         if #patt2 >= i+1 then
            newPatt[#newPatt+1] = patt2[i]
            newPatt[#newPatt+1] = patt2[i+1]
            newPatt[#newPatt+1] = 2
         end
      end
   end

   if #newPatt%2 == 0 then  
      newPatt[#newPatt+1] = 0
   end
   return (newPatt)
end
--==================================================================

------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.run(segmentNo)

   ---------------------  script data-----------------------
   --  GENS =
   ---------------------------------------------------------
   local currindex = g.getlayer()
   local changeLayName = "ChangeLay"
   local changeLay
   local oldLay
   local gen = g.getgen()
   
   local oldPatt = threeState2two(g.getcells(g.getrect()))
   while ( g.numlayers() > currindex+1 ) do
      g.setlayer(g.numlayers()-1)
      g.dellayer()
   end
   g.setlayer(g.numlayers()-1)
   changeLay = g.addlayer()
   g.setname(changeLayName)
   g.setgen(gen)
   
   local patt, newPatt
   g.setlayer(currindex)   
   newPatt = threeState2two(g.getcells(g.getrect()))
   for st = 1,scriptFileData.GENS do
      g.setlayer(changeLay)
      oldLay = g.addlayer()
      g.putcells(newPatt,0, 0, 1, 0, 0, 1, "copy")
      g.setlayer(currindex)
      g.run(1)
      newPatt = threeState2two(g.getcells(g.getrect()))
      g.setlayer(oldLay)
      g.putcells(newPatt,0, 0, 1, 0, 0, 1, "xor")
      patt = g.getcells(g.getrect())
      g.dellayer()
      g.putcells(patt,0, 0, 1, 0, 0, 1, "or")
   end
   if ( scriptFileData.ONECHANGE ) then
      -- Remove changed cells from base pattern so that all changed cells are the same colour when layers are stacked
      g.update()
      patt = g.getcells(g.getrect())  -- from the change layer
      g.setlayer(currindex)
      if (g.numstates() == 3) then
         g.putcells(patt,0, 0, 1, 0, 0, 1, "xor")  -- works for 3 state
      else
         g.putcells(patt,0, 0, 1, 0, 0, 1, "not")  -- works for 2 state
      end
      logStates("lay1", newPatt)
      logStates("lay2", patt)
      g.update()
      logStates("lay1 updated", g.getcells(g.getrect()))
   end
   g.setlayer(changeLay)
   if (g.numstates() > 2) then
      cellNotSet = 2
      g.setcolors({2,255,255,255, 1,255,0,0, 0,255,255,255})  --2 white, 1-red, 0-white
   else
      g.setcolors({1,255,0,0})
   end
   g.setlayer(currindex) 
   if (g.numstates() > 2) then
      g.setcolors({2,255,255,255, 1,0,0,0, 0,255,255,255})  --2 white, 1-black, 0-white
   else
      g.setcolors({1,0,0,0})
   end
end   
return m
------------------------------------------------------------
------------------------------------------ eof -----------------------------------------
